/**
 * Projet Dmo JDBC-SQL
 */
package fr.bouget.main;

import java.sql.SQLException;
import java.util.ArrayList;

import javax.swing.JOptionPane;

import fr.bouget.connection.AccesBD;
import fr.bouget.metier.Requetes;
import fr.bouget.model.Avion;
import fr.bouget.model.Pilote;
import fr.bouget.model.Vol;

/**
 * @author Philippe
 *
 */
public class Application {

	
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		
		try {
				// Les requtes SELECT
			
					System.out.println("Requtes diverses sans manipulation d'objet :\n");
					Requetes.requetesBasiquesSansObjet();
					System.out.println("=================================================================");
					
					System.out.println("\n\nListe des Avions avec getAllAvions() :\n");
					ArrayList<Avion> avions = new ArrayList<Avion>();
					avions = Requetes.getAllAvions();
					for (Avion avion : avions)	{	System.out.println(avion);	}
					
					System.out.println("=================================================================");
					System.out.println("\n\nAvion N 102 avec getAvionById(102) :\n");
					System.out.println(Requetes.getAvionById(102));
					
					System.out.println("=================================================================");
					System.out.println("\n\nPilote N 8 avec getPiloteById(8) :\n");
					System.out.println(Requetes.getPiloteById(8));
					
					System.out.println("=================================================================");
					System.out.println("\n\nListe des vols avec getAllVols() :\n");
					System.out.println("Cette mthode utilise le Mapping avec des objets Avions et Pilotes :\n");
					for (Vol vol : Requetes.getAllVols())	{	System.out.println(vol);	}
					System.out.println("=================================================================");
			
					
					System.out.println(Requetes.getAvionById(Integer.parseInt(JOptionPane.showInputDialog("Saisissez un numro d'avion (entre 100 et 109)  afficher"))));
			
					// Les requtes UPDATE avec la table Pilote 
					
					// Ajouter de 2 nouveaux Pilotes dans la table (La gnration de la clef n'est pas automatique prvoir une astuce)
					System.out.println("\n\n=================================================================");
					System.out.println("\n\nAjout de 2 nouveaux pilotes (Grard et Elodie) :\n");
					// cration de mon objet "nouveauPilote" de type Pilote
					Pilote nouveauPilote = new Pilote();
					nouveauPilote.setId(Requetes.getNombreDePilote()+1);
					nouveauPilote.setNom("Grard");
					nouveauPilote.setSite("MARSEILLE");
					
					Requetes.ajouterPilote(nouveauPilote);
					
					nouveauPilote.setId(Requetes.getNombreDePilote()+1);
					nouveauPilote.setNom("Elodie");
					nouveauPilote.setSite("BREST");
					
					Requetes.ajouterPilote(nouveauPilote);
					
					// on modifie le site du pilote Grard (n10) qui devient Paris au lieu de Marseille.
					System.out.println("\n\n=================================================================");
					System.out.println("\n\nOn modifie le site du pilote Grard, ce n'est plus le soleil de Marseille mais celui de Paris :\n");
					Pilote gege = Requetes.getPiloteById(10);
					gege.setSite("Paris");
					Requetes.modifierPilote(gege);
					
					// on affiche tous les pilotes pour voir les changements :
					
					System.out.println("=================================================================");
					
					System.out.println("\n\nListe des Pilotes avec getAllPilotes() :\n");
					for (Pilote p : Requetes.getAllPilotes())	{	System.out.println(p);	}
					
					// pour la suppression d'un pilote N 11 dans la base on suppose que l'objet Pilote est charg en mmoire avec un identifiant.
					System.out.println("\n\n=================================================================");
					System.out.println("\n\nsuppression d'un pilote N 11 :\n");
					Pilote monPilote = Requetes.getPiloteById(11);
					if (monPilote!=null)
					{
						// je l'affiche
						System.out.println(monPilote);
						
						// je le supprime (pan !! pan !! il est mort... dans la base de donnes uniquement ;) nous ne sommes pas une organisation criminelle !! 
						
						Requetes.supprimerPilote(monPilote);
					
					}
			
			
			

		} catch (ClassNotFoundException e) {
			
			e.printStackTrace();
		} catch (SQLException e) {
			
			e.printStackTrace();
		}
	}

}
