package fr.bouget.demoJDBC;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

/*		
1. Charger le pilote
2. Ouvrir une connexion  la base de donnes
3. Prparer la requte SQL
4. Excuter la requte
5. Rcuprer les rsultats (que l'on peut afficher ou pas)
	5.1 Afficher les rsultats si (SELECT)
	5.2 Retourner une information si (INSERT, UPDATE ou DELETE)
6. Fermer la connexion  la base de donnes.

Les tapes 1, 2 et 3 ne se font qu'une seule fois car elles sont communes pour excuter les tapes 3, 4 et 5

tests sur la table : apprenants_promo13


  CREATE TABLE `apprenants_promo13` (
  `id_apprenant` int(2) PRIMARY KEY NOT NULL AUTO_INCREMENT,
  `prenom` varchar(40) NOT NULL,
  `nom` varchar(40) NOT NULL
 ) ENGINE=InnoDB DEFAULT CHARSET=utf8;


insert into apprenants_promo13 (id_apprenant, prenom, nom) values (1, 'Page', 'Bouch');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (2, 'Doloritas', 'Wivell');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (3, 'Davie', 'Bruna');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (4, 'Ellen', 'Poynton');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (5, 'Karlene', 'Barnhill');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (6, 'Raynard', 'Edmeads');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (7, 'Taddeo', 'Paule');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (8, 'Leonid', 'Fowley');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (9, 'Daphna', 'Gavahan');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (10, 'Alfons', 'Schreiner');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (11, 'Aundrea', 'Kelmere');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (12, 'Merill', 'Merrett');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (13, 'Kiel', 'Sellner');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (14, 'Dulciana', 'MacCafferky');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (15, 'Elsi', 'Crust');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (16, 'Wallis', 'Kirkup');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (17, 'Shandy', 'Gutman');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (18, 'Lotti', 'Gilham');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (19, 'Vinita', 'Shane');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (20, 'Pamella', 'Mulderrig');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (21, 'Taber', 'O''Flaherty');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (22, 'Steve', 'Du Hamel');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (23, 'Ursala', 'Bernli');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (24, 'Geoff', 'Kinnear');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (25, 'Tabby', 'Palister');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (26, 'Lesli', 'Bulluck');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (27, 'Stefan', 'Tolussi');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (28, 'Emmi', 'L''argent');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (29, 'Sascha', 'Tatters');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (30, 'Zolly', 'Navaro');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (31, 'Isabel', 'Draco');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (32, 'Dwayne', 'Ribey');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (33, 'Tomkin', 'Bartlett');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (34, 'Lily', 'Darwood');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (35, 'Kelvin', 'Fuentes');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (36, 'Elsinore', 'Karpol');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (37, 'Kathlin', 'Calderwood');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (38, 'Myrvyn', 'Chugg');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (39, 'Thoma', 'Allchin');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (40, 'Willie', 'Gehrels');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (41, 'Pryce', 'Woodyeare');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (42, 'Kale', 'Mott');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (43, 'Natal', 'Trelease');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (44, 'Carolynn', 'Balshaw');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (45, 'Franklyn', 'Cressor');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (46, 'Devan', 'Hazeley');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (47, 'Raimundo', 'Port');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (48, 'Lilyan', 'Robyns');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (49, 'Berni', 'Olyunin');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (50, 'Bord', 'Farr');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (51, 'Antonella', 'Peplaw');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (52, 'Kassi', 'Hamstead');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (53, 'Thacher', 'Gatch');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (54, 'Babbie', 'Curtain');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (55, 'Rowan', 'Carthy');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (56, 'Fernanda', 'Wethey');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (57, 'Orlan', 'Whittet');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (58, 'Mariann', 'Robbins');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (59, 'Bryana', 'Mobius');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (60, 'Benedick', 'Astill');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (61, 'Dyane', 'Pittham');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (62, 'Lola', 'Kimber');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (63, 'Meir', 'Hampe');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (64, 'Windy', 'Booker');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (65, 'Lammond', 'Farrear');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (66, 'Sigismundo', 'Peyntue');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (67, 'Mordy', 'Fearnall');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (68, 'Mignon', 'Rotge');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (69, 'Garwood', 'Andreia');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (70, 'Haskell', 'Kolodziej');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (71, 'Gib', 'Ledur');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (72, 'Leland', 'Vallow');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (73, 'Codee', 'Greeve');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (74, 'Jessamyn', 'Statham');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (75, 'Gannie', 'Carrane');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (76, 'Aundrea', 'Griggs');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (77, 'Paddie', 'Pesak');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (78, 'Rollo', 'Winspar');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (79, 'Zedekiah', 'Santorini');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (80, 'Minerva', 'Louch');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (81, 'Innis', 'Kures');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (82, 'Robinia', 'Bramsen');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (83, 'Shelton', 'Jacobovitch');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (84, 'Margret', 'Knewstubb');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (85, 'Bailey', 'Gethin');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (86, 'Kasper', 'Bruin');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (87, 'Rodger', 'Quarterman');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (88, 'Birgit', 'Sallenger');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (89, 'Karlyn', 'Raftery');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (90, 'Sonnie', 'Phythean');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (91, 'Milicent', 'Bletso');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (92, 'Agnella', 'Trundle');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (93, 'Luci', 'Ladds');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (94, 'Cecilius', 'Keward');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (95, 'Clive', 'Cracker');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (96, 'Ammamaria', 'Santos');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (97, 'Mendie', 'Willeman');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (98, 'Hogan', 'Thaine');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (99, 'Crichton', 'Biaggiotti');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (100, 'Sallee', 'Bell');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (101, 'Lucina', 'Pople');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (102, 'Eugenia', 'Guerrier');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (103, 'Randie', 'Alwell');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (104, 'Madelon', 'Romi');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (105, 'Monti', 'Napthine');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (106, 'Charmane', 'Blaydon');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (107, 'Petra', 'Marti');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (108, 'Rebekkah', 'Lared');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (109, 'Glory', 'Aldridge');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (110, 'Justus', 'Emmott');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (111, 'Dew', 'Cristofari');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (112, 'Inez', 'Couth');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (113, 'Pammi', 'Myner');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (114, 'Henka', 'Murray');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (115, 'Wain', 'Etheridge');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (116, 'Cate', 'Bitterton');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (117, 'Aida', 'Ferrierio');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (118, 'Hillary', 'Wilden');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (119, 'Nickolaus', 'Shreve');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (120, 'Jerrine', 'Dunckley');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (121, 'Curr', 'Gossage');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (122, 'Baxie', 'Whetland');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (123, 'Filippa', 'Augur');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (124, 'Verena', 'Dibdin');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (125, 'Genna', 'Bills');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (126, 'Marlo', 'Holhouse');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (127, 'Abby', 'Deery');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (128, 'Laurice', 'Boow');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (129, 'Warren', 'Cassey');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (130, 'Yehudit', 'Crilley');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (131, 'Gherardo', 'Hunnicot');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (132, 'Milt', 'Coalburn');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (133, 'Noelle', 'Elener');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (134, 'Baryram', 'Awmack');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (135, 'Philipa', 'Gibard');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (136, 'Mahalia', 'Stentiford');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (137, 'Mendie', 'Peyntue');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (138, 'Pamela', 'Power');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (139, 'Barbi', 'Strotone');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (140, 'Bendite', 'Mecchi');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (141, 'Duky', 'Jirsa');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (142, 'Lynnell', 'Jeckells');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (143, 'Nickola', 'Stobie');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (144, 'Layton', 'Thurley');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (145, 'Anita', 'Brusle');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (146, 'King', 'Edrich');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (147, 'Zollie', 'De Ferraris');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (148, 'Forbes', 'Tertre');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (149, 'Maressa', 'Recher');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (150, 'Arlana', 'Challinor');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (151, 'Shela', 'Lampart');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (152, 'Laureen', 'Savine');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (153, 'Frannie', 'Eymer');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (154, 'Linell', 'MacLice');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (155, 'Roxy', 'Essam');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (156, 'Durand', 'Volker');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (157, 'Marlena', 'Strain');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (158, 'Rheta', 'Cicchillo');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (159, 'Solomon', 'Caston');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (160, 'Yuri', 'Pesterfield');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (161, 'Lottie', 'Ollie');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (162, 'Madeleine', 'Dumphries');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (163, 'Rebecca', 'Gready');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (164, 'Estevan', 'Van den Broek');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (165, 'Jaquelyn', 'Ruperti');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (166, 'Kali', 'Logg');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (167, 'Kienan', 'Sulley');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (168, 'Francine', 'Teenan');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (169, 'Forrester', 'Carlow');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (170, 'Phillida', 'Joontjes');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (171, 'Sabra', 'Cosker');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (172, 'Luciana', 'Grestye');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (173, 'Leontine', 'Pettifor');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (174, 'Miles', 'Nutkin');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (175, 'Kelci', 'Daid');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (176, 'Charline', 'Joney');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (177, 'Giff', 'Allred');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (178, 'Nixie', 'Cuddehy');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (179, 'Bari', 'Barnwille');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (180, 'Corbin', 'Allot');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (181, 'Benni', 'Kaley');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (182, 'Marthe', 'Dulinty');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (183, 'Brietta', 'Hoggan');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (184, 'Allyn', 'Mustoo');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (185, 'Chen', 'Theurer');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (186, 'Zarla', 'Skep');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (187, 'Annabella', 'Purshouse');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (188, 'Boyd', 'Thripp');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (189, 'Pansie', 'Dubique');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (190, 'Scarface', 'Tott');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (191, 'Ivett', 'Tidman');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (192, 'Devin', 'Eskrigg');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (193, 'Micheal', 'Skamell');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (194, 'Godiva', 'de Clerk');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (195, 'Noland', 'Capaldo');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (196, 'Esme', 'Danels');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (197, 'Frank', 'Shobbrook');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (198, 'Zonda', 'Umpleby');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (199, 'Linnie', 'MacGeaney');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (200, 'Felicle', 'Willows');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (201, 'Nickey', 'Sollowaye');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (202, 'Brook', 'Bruster');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (203, 'Darsey', 'Beau');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (204, 'Gabi', 'Jeanet');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (205, 'Lian', 'Dorrell');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (206, 'Verile', 'Lehrle');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (207, 'Cami', 'Batalle');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (208, 'Teddie', 'Haughton');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (209, 'Teodora', 'Ferson');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (210, 'Lola', 'Knutton');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (211, 'Chrystel', 'Jiggens');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (212, 'Nikos', 'Pritty');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (213, 'Eldon', 'Deathridge');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (214, 'Mayor', 'Thaxter');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (215, 'Rees', 'Ladbrooke');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (216, 'Donny', 'Jachimiak');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (217, 'Adriena', 'Dimblebee');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (218, 'Matthias', 'Krabbe');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (219, 'Alfons', 'Shingler');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (220, 'Davy', 'Sipson');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (221, 'Caz', 'Kelwaybamber');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (222, 'Yettie', 'Meiningen');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (223, 'Trevar', 'Gonsalvo');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (224, 'Dannel', 'Skill');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (225, 'Tressa', 'Archibould');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (226, 'Jen', 'Mawne');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (227, 'Kate', 'Dodamead');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (228, 'Ingamar', 'Hoovart');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (229, 'Monika', 'Satteford');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (230, 'Rolf', 'Arnaudon');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (231, 'Hogan', 'Tomeo');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (232, 'Mattheus', 'Davey');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (233, 'Gretal', 'Garter');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (234, 'Maximo', 'Tottie');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (235, 'Brien', 'Ruegg');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (236, 'Mychal', 'Boulding');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (237, 'Dotti', 'Falck');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (238, 'Ingmar', 'Tuxell');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (239, 'Rodrigo', 'Crisp');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (240, 'Doralia', 'Jerrand');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (241, 'Liza', 'Wandrich');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (242, 'Albie', 'Parkyn');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (243, 'Ianthe', 'Laybourn');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (244, 'Robinette', 'Powelee');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (245, 'Klara', 'Orpen');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (246, 'Durward', 'Joselevitch');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (247, 'Donn', 'Bednell');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (248, 'Osborne', 'Baudichon');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (249, 'Kinna', 'Shavel');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (250, 'Licha', 'Casterou');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (251, 'Johnny', 'Everleigh');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (252, 'Clemmie', 'Diplock');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (253, 'Ned', 'Bareford');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (254, 'Gwyneth', 'Shaefer');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (255, 'Reynolds', 'Terran');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (256, 'Lindsey', 'Scardifield');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (257, 'Nonie', 'Egerton');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (258, 'Margarita', 'Glenfield');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (259, 'Willie', 'Crellim');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (260, 'Nathalia', 'Constanza');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (261, 'Effie', 'Naire');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (262, 'Towny', 'Ashworth');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (263, 'Merl', 'Feaviour');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (264, 'Bradney', 'Westbrook');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (265, 'Heida', 'Trulock');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (266, 'Sumner', 'Kingsland');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (267, 'Merrily', 'Extall');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (268, 'Stormy', 'Covey');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (269, 'Corrianne', 'Gauchier');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (270, 'Myra', 'Tootal');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (271, 'Alexio', 'Longstreet');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (272, 'Gratia', 'Hearfield');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (273, 'Leesa', 'Raffon');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (274, 'Burt', 'Altamirano');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (275, 'Carmel', 'Mowsdill');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (276, 'Thoma', 'Kelk');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (277, 'Karole', 'Westcot');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (278, 'Kristopher', 'Ivanovic');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (279, 'Guglielmo', 'Turrill');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (280, 'Duncan', 'Zammitt');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (281, 'Rene', 'Shackel');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (282, 'Olag', 'Kleint');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (283, 'Hyman', 'Paolino');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (284, 'Fitz', 'Mulhall');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (285, 'Blondie', 'Fairfoot');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (286, 'Jill', 'Yitzowitz');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (287, 'Tremaine', 'Clemenzo');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (288, 'Hermon', 'O''Doherty');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (289, 'Teresa', 'Bartolomivis');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (290, 'Nial', 'Albrighton');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (291, 'Kaspar', 'Lie');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (292, 'Gustaf', 'Monroe');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (293, 'Antons', 'Bladder');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (294, 'Conroy', 'Ranklin');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (295, 'Karoline', 'Copper');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (296, 'Lilli', 'Ortler');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (297, 'Marieann', 'Dennerly');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (298, 'Kirstin', 'Dulany');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (299, 'Dex', 'Bonnet');
insert into apprenants_promo13 (id_apprenant, prenom, nom) values (300, 'Francis', 'Halbord');


*/	

public class JdbcDemonstration {


	/**
	 * @param args
	 */
	public static void main(String[] args)
{
		String url = "jdbc:mysql://localhost:3306/pratique";
		String user = "root";
		String password = "";
	
		try {
			// 1. Charger le pilote (pilote JDBC pour MySQL dans le package concern)
				Class.forName("com.mysql.jdbc.Driver");
				
			// 2. Ouvrir une connexion  la base de donnes (dans la classe DriverManager, il y a une mthode getConnection()
				
				Connection connection = DriverManager.getConnection(url, user, password);
			
			//	3. Prparer la requte SQL
				
				String sql = "SELECT * FROM apprenants_promo3 ORDER BY nom";
			
			//	4. Excuter la requte
				
				Statement instruction = null;					// dclaration
				instruction = connection.createStatement();		// initialisation
				
			// 5. Rcuprer les rsultats
				
				ResultSet resultat = null;
				resultat = instruction.executeQuery(sql);		// excution et rcupration du rsultat
				
			// 5.1 on souhaite afficher les rsultas de notre requte (utilisation d'une Boucle)
				
				// 5.1.1 Vous ne connaissez pas le nom des colonnes, juste le nombre (ici 3 colonnes)
				System.out.println("\n\n5.1.1 Vous ne connaissez pas le nom des colonnes, juste le nombre (ici 3 colonnes) : \n");
				while (resultat.next()) // tant qu'il y a des enregistrements
				{
					System.out.print(resultat.getString(1)+" ");
					System.out.print(resultat.getString(2)+ " ");
					System.out.println(resultat.getString(3));
				}
				
				// 5.1.2 Vous connaissez le nom des colonnes de la table
				System.out.println("\n\n5.1.2 Vous connaissez le nom des colonnes de la table : \n");
				resultat.beforeFirst(); // on se repositionne (on dplace le curseur des enregistrements avant le premier enregistrement)
				
				while (resultat.next()) // tant qu'il y a des enregistrements
				{
					System.out.print(resultat.getString("id_apprenant")+" ");
					System.out.print(resultat.getString("prenom")+ " ");
					System.out.println(resultat.getString("nom"));
				}
				
				// 6. Fermer la connexion  la base de donnes.
			
				connection.close();	
				
		} catch (ClassNotFoundException cnfe) 
		{
			
			System.out.println("Pilote introuvable !");
			cnfe.printStackTrace();
		}
		catch(SQLException sqle)
		{
			System.out.println("Problme de connection !");
			sqle.printStackTrace();
		}

}

}
